# GreatestCommonDivisor
<span class="source-link">[[Source]](src/math/greatest_common_divisor.md#L-0-1)</span>

Get greatest common divisor of x and y.

Providing 0 will result in an error.

Example usage:

```pony
use "math"

actor Main
  new create(env: Env) =>
    try
      let gcd = GreatestCommonDivisor[I64](10, 20)?
      env.out.print(gcd.string())
    else
      env.out.print("No GCD")
    end
```


```pony
primitive val GreatestCommonDivisor
```

## Constructors

### create
<span class="source-link">[[Source]](src/math/greatest_common_divisor.md#L-0-1)</span>


```pony
new val create()
: GreatestCommonDivisor val^
```

#### Returns

* [GreatestCommonDivisor](math-GreatestCommonDivisor.md) val^

---

## Public Functions

### apply\[A: [Integer](builtin-Integer.md)\[A\] val\]
<span class="source-link">[[Source]](src/math/greatest_common_divisor.md#L-0-22)</span>


```pony
fun box apply[A: Integer[A] val](
  x: A,
  y: A)
: A ?
```
#### Parameters

*   x: A
*   y: A

#### Returns

* A ?

---

### eq
<span class="source-link">[[Source]](src/math/greatest_common_divisor.md#L-0-22)</span>


```pony
fun box eq(
  that: GreatestCommonDivisor val)
: Bool val
```
#### Parameters

*   that: [GreatestCommonDivisor](math-GreatestCommonDivisor.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/math/greatest_common_divisor.md#L-0-22)</span>


```pony
fun box ne(
  that: GreatestCommonDivisor val)
: Bool val
```
#### Parameters

*   that: [GreatestCommonDivisor](math-GreatestCommonDivisor.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

