/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.saml2.metadata.AssertionIDRequestService;
import org.opensaml.saml.saml2.metadata.AuthzService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.impl.RoleDescriptorImpl;

public class PDPDescriptorImpl
extends RoleDescriptorImpl
implements PDPDescriptor {
    @Nonnull
    private final XMLObjectChildrenList<AuthzService> authzServices = new XMLObjectChildrenList(this);
    @Nonnull
    private final XMLObjectChildrenList<AssertionIDRequestService> assertionIDRequestServices = new XMLObjectChildrenList(this);
    @Nonnull
    private final XMLObjectChildrenList<NameIDFormat> nameIDFormats = new XMLObjectChildrenList(this);

    protected PDPDescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nonnull
    @Live
    public List<AuthzService> getAuthzServices() {
        return this.authzServices;
    }

    @Override
    @Nonnull
    @Live
    public List<AssertionIDRequestService> getAssertionIDRequestServices() {
        return this.assertionIDRequestServices;
    }

    @Override
    @Nonnull
    @Live
    public List<NameIDFormat> getNameIDFormats() {
        return this.nameIDFormats;
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.addAll(this.authzServices);
        endpoints.addAll(this.assertionIDRequestServices);
        return CollectionSupport.copyToList(endpoints);
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints(@Nonnull QName type) {
        if (type.equals(AuthzService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.authzServices);
        }
        if (type.equals(AssertionIDRequestService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.assertionIDRequestServices);
        }
        return CollectionSupport.emptyList();
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        List<XMLObject> parentChildren = super.getOrderedChildren();
        if (parentChildren != null) {
            children.addAll(parentChildren);
        }
        children.addAll(this.authzServices);
        children.addAll(this.assertionIDRequestServices);
        children.addAll(this.nameIDFormats);
        return CollectionSupport.copyToList(children);
    }
}

