/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropViewFinalStep;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropViewImpl
extends AbstractQuery
implements DropViewFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_VIEW};
    private final Table<?> table;
    private final boolean ifExists;

    DropViewImpl(Configuration configuration, Table<?> table) {
        this(configuration, table, false);
    }

    DropViewImpl(Configuration configuration, Table<?> table, boolean ifExists) {
        super(configuration);
        this.table = table;
        this.ifExists = ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_VIEW);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_VIEW);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_VIEW_TABLE).visit(Keywords.K_DROP_VIEW).sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.table);
        ctx.end(Clause.DROP_VIEW_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

