/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.updater.jetty;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.Authorization;
import org.eclipse.jetty.client.security.ProxyAuthorization;
import org.eclipse.jetty.client.security.Realm;
import org.eclipse.jetty.client.security.RealmResolver;
import org.eclipse.jetty.http.HttpFields;
import org.sonatype.nexus.index.updater.AbstractResourceFetcher;
import org.sonatype.nexus.index.updater.ResourceFetcher;
import org.sonatype.nexus.index.updater.jetty.NtlmConnectionHelper;
import org.sonatype.nexus.index.updater.jetty.NtlmListener;
import org.sonatype.nexus.index.updater.jetty.ResourceExchange;
import org.sonatype.nexus.index.updater.jetty.TransferListenerSupport;

public class JettyResourceFetcher
extends AbstractResourceFetcher
implements ResourceFetcher {
    private int maxConnections;
    private int connectionTimeoutMs = 30000;
    private int transactionTimeoutMs = 1800000;
    private boolean useCache;
    private ProxyInfo proxyInfo;
    private AuthenticationInfo authenticationInfo;
    private HttpFields headers;
    private int maxRedirects = 4;
    private HttpClient httpClient;
    private String host;
    private String url;
    private final TransferListenerSupport listenerSupport = new TransferListenerSupport();

    public void retrieve(String name, File targetFile) throws IOException, FileNotFoundException {
        HttpFields exchangeHeaders = this.buildHeaders();
        StringBuilder getUrl = new StringBuilder(this.url);
        if (getUrl.charAt(getUrl.length() - 1) != '/' && !name.startsWith("/")) {
            getUrl.append('/');
        }
        getUrl.append(name);
        ResourceExchange exchange = new ResourceExchange(targetFile, exchangeHeaders, this.maxRedirects, getUrl.toString(), this.listenerSupport);
        exchange = this.get(exchange);
        while (exchange.prepareForRedirect()) {
            exchange = this.get(exchange);
        }
        if (exchange.isRedirectionPrevented()) {
            throw new IOException("Too many redirects (" + exchange.getRedirectCount() + ").");
        }
    }

    private ResourceExchange get(ResourceExchange exchange) throws IOException {
        String url = exchange.getOriginalUrl();
        this.httpClient.send((HttpExchange)exchange);
        try {
            if (!exchange.waitFor(this.transactionTimeoutMs)) {
                this.listenerSupport.fireTransferError(url, new IOException("Transaction timed out."), 5);
            }
        }
        catch (InterruptedException e) {
            IOException err = new IOException("Transfer interrupted: " + e.getMessage());
            err.initCause(e);
            throw err;
        }
        if (!exchange.isFinished()) {
            exchange.cancel();
            throw new IOException("Transfer timed out.");
        }
        int responseStatus = exchange.getResponseStatus();
        switch (responseStatus) {
            case 200: 
            case 301: 
            case 302: 
            case 304: {
                break;
            }
            case 403: {
                throw new IOException("Transfer failed: [" + responseStatus + "] " + url);
            }
            case 401: {
                throw new IOException("Transfer failed: Not authorized");
            }
            case 407: {
                throw new IOException("Transfer failed: Not authorized by proxy");
            }
            case 404: {
                throw new IOException("Transfer failed: " + url + " does not exist");
            }
            default: {
                IOException ex = new IOException("Transfer failed: [" + responseStatus + "] " + url);
                this.listenerSupport.fireTransferError(url, ex, 5);
                throw ex;
            }
        }
        return exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String id, String url) throws IOException {
        this.url = url;
        URL u = new URL(url);
        this.host = u.getHost();
        this.httpClient = new HttpClient();
        this.httpClient.setConnectorType(2);
        if (this.maxConnections > 0) {
            this.httpClient.setMaxConnectionsPerAddress(this.maxConnections);
        }
        if (this.connectionTimeoutMs > 0) {
            this.httpClient.setTimeout((long)this.connectionTimeoutMs);
        }
        this.httpClient.registerListener(NtlmListener.class.getName());
        NtlmListener.setHelper(new NtlmConnectionHelper(this));
        this.setupClient();
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            try {
                this.disconnect();
            }
            catch (IOException internalError) {
            }
            finally {
                this.httpClient = null;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException err = new IOException(e.getLocalizedMessage());
            err.initCause(e);
            throw err;
        }
    }

    public void disconnect() throws IOException {
        if (this.httpClient != null) {
            try {
                this.httpClient.stop();
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException err = new IOException(e.getLocalizedMessage());
                err.initCause(e);
                throw err;
            }
            finally {
                this.httpClient = null;
            }
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public HttpFields getHttpHeaders() {
        return this.headers;
    }

    protected void setupClient() throws IOException {
        if (this.proxyInfo != null && this.proxyInfo.getHost() != null) {
            String proxyType = this.proxyInfo.getType();
            if (!proxyType.equalsIgnoreCase("HTTP".toLowerCase())) {
                throw new IOException("Connection failed: " + proxyType + " is not supported");
            }
            this.httpClient.setProxy(new Address(this.proxyInfo.getHost(), this.proxyInfo.getPort()));
            if (this.proxyInfo.getUserName() != null) {
                this.httpClient.setProxyAuthentication((Authorization)new ProxyAuthorization(this.proxyInfo.getUserName(), this.proxyInfo.getPassword()));
            }
        }
        final String targetHost = this.host;
        AuthenticationInfo authInfo = this.getAuthenticationInfo();
        if (authInfo != null && authInfo.getUserName() != null) {
            this.httpClient.setRealmResolver(new RealmResolver(){

                public Realm getRealm(String realmName, HttpDestination destination, String path) throws IOException {
                    return new Realm(){

                        public String getCredentials() {
                            return JettyResourceFetcher.this.getAuthenticationInfo().getPassword();
                        }

                        public String getPrincipal() {
                            return JettyResourceFetcher.this.getAuthenticationInfo().getUserName();
                        }

                        public String getId() {
                            return targetHost;
                        }
                    };
                }
            });
        }
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public JettyResourceFetcher setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public JettyResourceFetcher setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMs;
    }

    public JettyResourceFetcher setConnectionTimeoutMillis(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
        return this;
    }

    public HttpFields getHeaders() {
        return this.headers;
    }

    public JettyResourceFetcher setHeaders(HttpFields headers) {
        this.headers = headers;
        return this;
    }

    public JettyResourceFetcher setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public JettyResourceFetcher setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
        return this;
    }

    public JettyResourceFetcher setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
        return this;
    }

    public JettyResourceFetcher addTransferListener(TransferListener listener) {
        this.listenerSupport.addTransferListener(listener);
        return this;
    }

    private HttpFields buildHeaders() {
        HttpFields result = new HttpFields();
        if (this.headers != null) {
            result.add(this.headers);
        } else {
            result.add("Accept-Encoding", "gzip");
            if (!this.useCache) {
                result.add("Pragma", "no-cache");
                result.add("Cache-Control", "no-cache, no-store");
            }
        }
        return result;
    }

    public int getTransactionTimeoutMillis() {
        return this.transactionTimeoutMs;
    }

    public JettyResourceFetcher setTransactionTimeoutMillis(int transactionTimeoutMs) {
        this.transactionTimeoutMs = transactionTimeoutMs;
        return this;
    }
}

