from typing import Any

from django.template import Node
from django.template.base import FilterExpression, NodeList, Parser, Token
from django.template.context import Context

register: Any

class GetAvailableLanguagesNode(Node):
    variable: str
    def __init__(self, variable: str) -> None: ...
    def render(self, context: Context) -> str: ...

class GetLanguageInfoNode(Node):
    lang_code: FilterExpression
    variable: str
    def __init__(self, lang_code: FilterExpression, variable: str) -> None: ...
    def render(self, context: Context) -> str: ...

class GetLanguageInfoListNode(Node):
    languages: FilterExpression
    variable: str
    def __init__(self, languages: FilterExpression, variable: str) -> None: ...
    def get_language_info(self, language: Any) -> Any: ...
    def render(self, context: Context) -> str: ...

class GetCurrentLanguageNode(Node):
    variable: str
    def __init__(self, variable: str) -> None: ...
    def render(self, context: Context) -> str: ...

class GetCurrentLanguageBidiNode(Node):
    variable: str
    def __init__(self, variable: str) -> None: ...
    def render(self, context: Context) -> str: ...

class TranslateNode(Node):
    noop: bool
    asvar: str | None
    message_context: FilterExpression | None
    filter_expression: FilterExpression
    def __init__(
        self,
        filter_expression: FilterExpression,
        noop: bool,
        asvar: str | None = None,
        message_context: FilterExpression | None = None,
    ) -> None: ...
    def render(self, context: Context) -> str: ...

class BlockTranslateNode(Node):
    extra_context: dict[str, FilterExpression]
    singular: list[Token]
    plural: list[Token]
    countervar: str | None
    counter: FilterExpression | None
    message_context: FilterExpression | None
    trimmed: bool
    asvar: str | None
    def __init__(
        self,
        extra_context: dict[str, FilterExpression],
        singular: list[Token],
        plural: list[Token] | None = None,
        countervar: str | None = None,
        counter: FilterExpression | None = None,
        message_context: FilterExpression | None = None,
        trimmed: bool = False,
        asvar: str | None = None,
        tag_name: str = "blocktranslate",
    ) -> None: ...
    def render_token_list(self, tokens: list[Token]) -> tuple[str, list[str]]: ...
    def render(self, context: Context, nested: bool = False) -> str: ...

class LanguageNode(Node):
    nodelist: NodeList
    language: FilterExpression
    def __init__(self, nodelist: NodeList, language: FilterExpression) -> None: ...
    def render(self, context: Context) -> str: ...

def do_get_available_languages(parser: Parser, token: Token) -> GetAvailableLanguagesNode: ...
def do_get_language_info(parser: Parser, token: Token) -> GetLanguageInfoNode: ...
def do_get_language_info_list(parser: Parser, token: Token) -> GetLanguageInfoListNode: ...
def language_name(lang_code: str) -> str: ...
def language_name_translated(lang_code: str) -> str: ...
def language_name_local(lang_code: str) -> str: ...
def language_bidi(lang_code: str) -> bool: ...
def do_get_current_language(parser: Parser, token: Token) -> GetCurrentLanguageNode: ...
def do_get_current_language_bidi(parser: Parser, token: Token) -> GetCurrentLanguageBidiNode: ...
def do_translate(parser: Parser, token: Token) -> TranslateNode: ...
def do_block_translate(parser: Parser, token: Token) -> BlockTranslateNode: ...
def language(parser: Parser, token: Token) -> LanguageNode: ...
