/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public final class GrSplitDeclarationIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            GrSplitDeclarationIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GrSplitDeclarationIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            GrSplitDeclarationIntention.$$$reportNull$$$0(2);
        }
        if (!(element instanceof GrVariableDeclaration)) {
            return;
        }
        GrVariableDeclaration declaration = (GrVariableDeclaration)element;
        Project project = context.project();
        GrVariable[] variables = declaration.getVariables();
        if (variables.length == 1) {
            GrSplitDeclarationIntention.processSingleVar(project, declaration, variables[0]);
        } else if (variables.length > 1) {
            if (!declaration.isTuple() || declaration.getTupleInitializer() instanceof GrListOrMap) {
                GrSplitDeclarationIntention.processMultipleVars(project, declaration);
            } else {
                GrSplitDeclarationIntention.processTuple(project, declaration);
            }
        }
    }

    private static void processTuple(Project project, GrVariableDeclaration declaration) {
        GrExpression initializer = declaration.getTupleInitializer();
        assert (initializer != null);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrVariable[] variables = declaration.getVariables();
        StringBuilder assignmentBuilder = new StringBuilder();
        assignmentBuilder.append('(');
        for (GrVariable variable : variables) {
            assignmentBuilder.append(variable.getName()).append(',');
        }
        assignmentBuilder.replace(assignmentBuilder.length() - 1, assignmentBuilder.length(), ")=");
        assignmentBuilder.append(initializer.getText());
        GrStatement assignment = factory.createStatementFromText(assignmentBuilder.toString());
        declaration = GroovyRefactoringUtil.addBlockIntoParent(declaration);
        declaration.getParent().addAfter((PsiElement)assignment, (PsiElement)declaration);
        initializer.delete();
    }

    private static void processMultipleVars(Project project, GrVariableDeclaration declaration) {
        int i2;
        GrVariable[] variables = declaration.getVariables();
        String modifiers = declaration.getModifierList().getText();
        GrStatement[] sts = new GrStatement[variables.length];
        for (i2 = 0; i2 < variables.length; ++i2) {
            sts[i2] = GrSplitDeclarationIntention.createVarDeclaration(project, variables[i2], modifiers, declaration.isTuple());
        }
        declaration = GroovyRefactoringUtil.addBlockIntoParent(declaration);
        for (i2 = sts.length - 1; i2 >= 0; --i2) {
            declaration.getParent().addAfter((PsiElement)sts[i2], (PsiElement)declaration);
        }
        declaration.delete();
    }

    private static void processSingleVar(Project project, GrVariableDeclaration declaration, GrVariable variable) {
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer != null) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            GrExpression assignment = factory.createExpressionFromText(variable.getName() + " = " + initializer.getText());
            initializer.delete();
            declaration = GroovyRefactoringUtil.addBlockIntoParent(declaration);
            declaration.getParent().addAfter((PsiElement)assignment, (PsiElement)declaration);
        }
    }

    private static GrStatement createVarDeclaration(Project project, GrVariable variable, String modifiers, boolean isTuple) {
        StringBuilder builder = new StringBuilder();
        builder.append(modifiers).append(' ');
        GrTypeElement typeElement = variable.getTypeElementGroovy();
        if (typeElement != null) {
            builder.append(typeElement.getText()).append(' ');
        }
        builder.append(variable.getName());
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer != null) {
            builder.append('=').append(initializer.getText());
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrVariableDeclaration decl = (GrVariableDeclaration)factory.createStatementFromText(builder);
        if (isTuple && (variable.getDeclaredType() != null || decl.getModifierList().getModifiers().length > 1)) {
            decl.getModifierList().setModifierProperty("def", false);
        }
        return decl;
    }

    @Override
    @NotNull
    @IntentionName
    public String getText(@NotNull PsiElement element) {
        GrVariableDeclaration decl;
        GrVariable[] variables;
        if (element == null) {
            GrSplitDeclarationIntention.$$$reportNull$$$0(3);
        }
        if ((variables = (decl = (GrVariableDeclaration)element).getVariables()).length > 1 && PsiUtil.isLocalVariable(variables[0]) && (!decl.isTuple() || decl.getTupleInitializer() instanceof GrListOrMap)) {
            String string = GroovyIntentionsBundle.message("split.into.separate.declaration", new Object[0]);
            if (string == null) {
                GrSplitDeclarationIntention.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = GroovyIntentionsBundle.message("split.into.declaration.and.assignment", new Object[0]);
        if (string == null) {
            GrSplitDeclarationIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(this){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof GrVariableDeclaration) {
                    GrVariableDeclaration decl = (GrVariableDeclaration)element;
                    Object[] variables = decl.getVariables();
                    return !ContainerUtil.exists((Object[])variables, v -> v.isUnnamed()) && (variables.length > 1 && PsiUtil.isLocalVariable((PsiElement)variables[0]) || variables.length == 1 && PsiUtil.isLocalVariable((PsiElement)variables[0]) && variables[0].getInitializerGroovy() != null);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention$1", "satisfiedBy"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/GrSplitDeclarationIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

