/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.action;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.action.ConfigurableRule;
import org.gradle.internal.action.ConfigurableRules;

public class DefaultConfigurableRules<DETAILS>
implements ConfigurableRules<DETAILS> {
    private final List<ConfigurableRule<DETAILS>> configurableRules;
    private final boolean cacheable;

    public static <T> ConfigurableRules<T> of(ConfigurableRule<T> unique) {
        return new DefaultConfigurableRules(Collections.singletonList(unique));
    }

    public DefaultConfigurableRules(List<ConfigurableRule<DETAILS>> rules) {
        this.configurableRules = ImmutableList.copyOf(rules);
        this.cacheable = this.computeCacheable();
    }

    private boolean computeCacheable() {
        boolean isCacheable = false;
        for (ConfigurableRule<DETAILS> configurableRule : this.configurableRules) {
            if (!configurableRule.isCacheable()) continue;
            isCacheable = true;
        }
        return isCacheable;
    }

    @Override
    public List<ConfigurableRule<DETAILS>> getConfigurableRules() {
        return this.configurableRules;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    public String toString() {
        return this.configurableRules.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConfigurableRules that = (DefaultConfigurableRules)o;
        return this.configurableRules.equals(that.configurableRules);
    }

    public int hashCode() {
        return this.configurableRules.hashCode();
    }
}

